#include "list.h"
#include "debug.h"
#include <string.h>
#include <stdlib.h>


void list_make(list *listo, int size)
{
	listo->names = (char**) malloc(sizeof(char*) * size);
	listo->items = (void**) malloc(sizeof(void*) * size);
	listo->item_count = 0;
	listo->max_count = size;
}

int list_add_item(list *listo, void *item, char *name)
{
	int name_length;
	char *new_name;
	
	listo->names[listo->item_count] = NULL;
	if(name != NULL)
	{
		name_length = strlen(name);
		new_name = (char*) malloc(sizeof(char) * name_length + 1);
		strncpy(new_name, name, name_length);
		listo->names[listo->item_count] = new_name;
	}

	listo->items[listo->item_count] = item;
	listo->item_count++;
	
	return listo->item_count-1;
}

char* list_print_items(list *listo)
{
	int i;

	for(i=0; i < listo->item_count; i++)
	{
		printd(NORMAL, "%s\n", listo->names[i]);
	}
	
	return NULL;
}

void* list_get_index(list *listo, int indx)
{
	if(indx < listo->item_count)
		return listo->items[indx];
	return NULL;
}

void* list_get_item(list *listo, void *item_to_find)
{
	int i = 0;
	
	for(i=0; i < listo->item_count; i++)
	{
		if(listo->items[i] == item_to_find)
			return listo->items[i];
	}
	
	return NULL;
}

void* list_get_name(list *listo, char *name)
{
	int i = 0;

	for(i=0; i < listo->item_count; i++)
	{
		if(strncmp(listo->names[i], name, strlen(name)) == 0)
			return listo->items[i];
	}
	
	return NULL;
}

void list_delete_item(list *listo, void *item)
{
	int i;
	
	for(i=0; i < listo->item_count; i++)
	{		
		if( listo->items[i] == item )
			list_delete_index(listo, i);
	}
}

void list_delete_name(list *listo, char *name)
{
	int i;
	int j;
	char remove = 0;
	
	//	int length_name = strlen(name);
	int item_name;
	
	if(name == NULL)
		return;
	
	for(i=0; i < listo->item_count; i++)
	{
		item_name = strlen(name);
				
		if( name != NULL && (strncmp(listo->names[i], name, strlen(name)) == 0) )
			list_delete_index(listo, i);
	}
}

void list_delete_index(list *listo, int indx)
{
	int j;
	
	//remove item
	if(listo->names[indx] != NULL)
		free(listo->names[indx]);
			
	//restructure
	for(j=indx; j < listo->item_count-1; j++)
	{
		listo->names[j] = listo->names[j+1];
		listo->items[j] = listo->items[j+1];
	}
	
	listo->item_count--;
	
	return;
}

void list_print_list(list *listo)
{
	int i;
	
	printd(NORMAL, "count: %i/%i\n", listo->item_count, listo->max_count);
	
	for(i=0; i < listo->item_count; i++)
	{
		printd(NORMAL, "list[%i]: %s\n", i, listo->names[i]);
	}
}

void test_list()
{
	list test;
	char *test1 = "besto";
	char *test2 = "copter";
	char *test3 = "i win";
	
	printd(NORMAL, "Making list...\n");
	list_make(&test, 10);
	list_print_list(&test);

	printd(NORMAL, "Adding 3 items...\n");
	list_add_item(&test, test1, "testo");
	list_add_item(&test, test2, "rofl");
	list_add_item(&test, test3, "lolz");
	list_print_list(&test);

	printd(NORMAL, "Removing \"testo\"...\n");	
	printd(NORMAL, "testo is: %s\n", list_get_name(&test, "testo"));
	list_delete_name(&test, "testo");
	list_print_list(&test);
}

